Attribute VB_Name = "Module2"
Option Explicit

Private Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Long) As Integer


Public Const WH_CALLWNDPROC = 4
Public Const WH_CALLWNDPROCRET = 12
Public Const WH_CBT = 5
Public Const WH_DEBUG = 9
Public Const WH_FOREGROUNDIDLE = 11
Public Const WH_GETMESSAGE = 3
Public Const WH_HARDWARE = 8
Public Const WH_JOURNALPLAYBACK = 1
Public Const WH_JOURNALRECORD = 0
Public Const WH_KEYBOARD = 2
Public Const WH_MAX = 11
Public Const WH_MIN = (-1)
Public Const WH_MOUSE = 7
Public Const WH_MSGFILTER = (-1)
Public Const WH_SHELL = 10
Public Const WH_SYSMSGFILTER = 6

Private Const HC_ACTION = 0
Private Const HC_GETNEXT = 1
Private Const HC_SKIP = 2
Private Const HC_NOREMOVE = 3
Private Const HC_NOREM = HC_NOREMOVE
Private Const HC_SYSMODALOFF = 5
Private Const HC_SYSMODALON = 4

Private Const SW_SHOWNORMAL = 1
Private Const VK_LWIN = &H5B

Public Type DEBUGHOOKINFO
        hModuleHook As Long
        Reserved As Long
        lParam As Long
        wParam As Long
        code As Long
End Type

Public Type POINTAPI
        x As Long
        y As Long
End Type

Public Type MSG
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type

Private hDBGHook As Long
Public IsDBGHooked As Boolean


Private hHook As Long
Public IsHooked As Boolean


'-----------------------------
' SET MESSAGE FILTER HOOK
'-----------------------------
Public Sub SetKeyboardHook()
    If IsHooked Then
        MsgBox "Don't hook WH_KEYBOARD twice or you will be unable to unhook it."
    Else
        hHook = SetWindowsHookEx(WH_KEYBOARD, AddressOf WndKeyBoardProc, 0, App.ThreadID)
        IsHooked = True
    End If
End Sub


Public Sub RemoveKeyboardHook()
    Dim RetVal As Long
    RetVal = UnhookWindowsHookEx(hHook)
    IsHooked = False
End Sub


Public Function WndKeyBoardProc(ByVal uCode As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    Dim bWinKeyDown As Boolean
    Dim bCharKeyUp As Boolean
    Dim iWinKeyState As Integer
    
    If uCode >= 0 Then
        Select Case uCode
            Case HC_ACTION
                'Form2.Text1.Text = Form2.Text1.Text & "KEYBOARD VK:" & Hex$(wParam) & "    lParam:" & lParam & vbNewLine
                'DoEvents
            
                iWinKeyState = GetAsyncKeyState(VK_LWIN)
                If (iWinKeyState And &H8000) = &H8000 Then
                    bWinKeyDown = True
                Else
                    bWinKeyDown = False
                End If

                If (lParam And &H80000000) = &H80000000 Then
                    'bKeyup=1   WM_KEYUP
                    bCharKeyUp = True
                Else
                    bCharKeyUp = False
                End If
                
                If ((Hex$(wParam) = "57") And bWinKeyDown And Not (bCharKeyUp)) Then
                    'If you do this on a keydown then you get 2-4 copies loaded
                    '  This only happens when the VB driver app is @ the foreground
                    Call Shell("C:\Program Files\Internet Explorer\Iexplore.exe", SW_SHOWNORMAL)

                    'Returning false disallows the w to be sent to the focus window
                    WndKeyBoardProc = 1
                    Exit Function
                End If
            Case HC_NOREMOVE
                'The message has not been removed from the message queue
            Case Else
                'Do nothing
        End Select
    End If
        
    WndKeyBoardProc = CallNextHookEx(hHook, uCode, wParam, lParam)
End Function




'-----------------------------
' SET DEBUG FILTER HOOK
'-----------------------------
Public Sub SetDebugHook()
    If IsDBGHooked Then
        MsgBox "Don't hook it twice or you will be unable to unhook it."
    Else
        hDBGHook = SetWindowsHookEx(WH_DEBUG, AddressOf DebugProc, 0, App.ThreadID)
        IsDBGHooked = True
    End If
End Sub


Public Sub RemoveDebugHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(hDBGHook)
    IsDBGHooked = False
End Sub


Public Function DebugProc(ByVal uCode As Long, ByVal wParam As Long, lParam As DEBUGHOOKINFO) As Long
    If uCode >= 0 Then
        Select Case wParam
            Case WH_KEYBOARD
                'Form2.Text1.Text = Form2.Text1.Text & "WH_KEYBOARD    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
        End Select
    End If
            
    'To prevent the system from calling the hook, the hook procedure must return a nonzero value
    DebugProc = CallNextHookEx(hDBGHook, uCode, wParam, lParam)
End Function

